#include <windows.h>
#include <stdio.h>
#include <string.h>

#define SBUF 256
HANDLE hnd=NULL;
char buff[SBUF];

char *find(char *name)
{
  WIN32_FIND_DATA ffd;

  if ((hnd = FindFirstFile(name, &ffd)) == NULL) {
     fprintf(stderr,"%s is not found.\n",name);
     return NULL;
  }

  if(ffd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
     buff[0] = '\0';
  else
     strcpy(buff, ffd.cFileName);
  return buff;
}

char *findn(char *name)
{
  BOOL res;
  HANDLE h;
  WIN32_FIND_DATA ffd;

  h = hnd;
  if(h) {
     if((res = FindNextFile(h, &ffd)) == FALSE)
	return NULL;
     if(ffd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
	buff[0] = '\0';
     else
	strcpy(buff, ffd.cFileName);
  }
  return buff;
}

int main(int argc, char **argv)
{
   char n[SBUF];
   char *p;
   char base[SBUF];
   char eps[SBUF];
   char dvi[SBUF];
   char log[SBUF];
   char aux[SBUF];
   char cmd[SBUF];
   int  len;

   strcpy(argv[0], "pst2pdf");
   if(argc > 2) {
      fprintf(stderr, "Usage: %s\n", argv[0]);
      fprintf(stderr, "     : %s NameHead\n", argv[0]);
      return 100;
   }

   if(argc == 2) {
      strcpy(n, argv[1]);
      strcat(n, "-fig*.tex");
   } else {
      strcpy(n, "*-fig*.tex");
   }

   p = find(n);
   if(p) {
      if(*p) {
	 strcpy(base, p);
	 len = strlen(base);
	 if(len > 4) {
	    base[len-4] = '\0';
	    strcpy(eps, base);
	    strcpy(dvi, base);
	    strcpy(log, base);
	    strcpy(aux, base);
	    strcat(eps, ".eps");
	    strcat(dvi, ".dvi");
	    strcat(log, ".log");
	    strcat(aux, ".aux");
	    strcpy(cmd, "platex --interaction=batchmode ");
	    strcat(cmd, base);
	    system(cmd);
	    strcpy(cmd, "dvips -Ppdf -E -o ");
	    strcat(cmd, eps);
	    strcat(cmd, " ");
	    strcat(cmd, base);
	    system(cmd);
	    strcpy(cmd, "epstopdf ");
	    strcat(cmd, eps);
	    system(cmd);
	    remove(eps);
	    remove(dvi);
	    remove(log);
	    remove(aux);
	 }
      }
      while((p=findn(n))) {
	 if(*p) {
	    strcpy(base, p);
	    len = strlen(base);
	    if(len > 4) {
	       base[len-4] = '\0';
	       strcpy(eps, base);
	       strcpy(dvi, base);
	       strcpy(log, base);
	       strcpy(aux, base);
	       strcat(eps, ".eps");
	       strcat(dvi, ".dvi");
	       strcat(log, ".log");
	       strcat(aux, ".aux");
	       strcpy(cmd, "platex --interaction=batchmode ");
	       strcat(cmd, base);
	       system(cmd);
	       strcpy(cmd, "dvips -Ppdf -E -o ");
	       strcat(cmd, eps);
	       strcat(cmd, " ");
	       strcat(cmd, base);
	       system(cmd);
	       strcpy(cmd, "epstopdf ");
	       strcat(cmd, eps);
	       system(cmd);
	       remove(eps);
	       remove(dvi);
	       remove(log);
	       remove(aux);
	    }
	 }
      }
   }
   if(hnd) FindClose(hnd);
   return 0;
}
